﻿using System;
using System.Globalization;
using System.Windows.Forms;

namespace Percent___Qualification_work.userControls
{
    public partial class Calendar : UserControl
    {
        public static int _year, _month;
        public Calendar()
        {
            InitializeComponent();
        }

        private void Calendar_Load(object sender, EventArgs e)
        {
            showDays(DateTime.Now.Month, DateTime.Now.Year);
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            _month -= 1;
            if (_month < 1 )
            {
                _month = 12;
                _year -= 1;
            }
            showDays(_month, _year);
        }

        private void btnNext_Click(object sender, EventArgs e)
        {
            _month += 1;
            if (_month == 12)
            {
                _month = 1;
                _year += 1;
            }
            showDays(_month,_year);
        }

        private void showDays(int month,int year)
        {
            flowLayoutPanel.Controls.Clear();
            _year = year;
            _month = month;

            string monthName = new DateTimeFormatInfo().GetMonthName(month);
            lbMonth.Text = monthName.ToUpper() + " " +  year;
            DateTime startodTheMonth = new DateTime(year, month, 1);
            int day = DateTime.DaysInMonth(year, month);
            int week = Convert.ToInt32(startodTheMonth.DayOfWeek.ToString("d"));

            for (int i = 1; i < week; i++)
            {
                ucDay uc = new ucDay("");
                flowLayoutPanel.Controls.Add(uc);
            }
            for (int i = 1; i <= day; i++) 
            {
                ucDay uc = new ucDay(i + "");
                flowLayoutPanel.Controls.Add(uc);
            }

        }
    }
}
